// Output a TSV of name\tfilename for all the event devices in /dev/input/event*.
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <linux/input.h>
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <unistd.h>

#define DEV_INPUT "/dev/input"

int main(int argc, char **argv) {
    DIR *dir;
    int fd;
    struct dirent *f;
    char name[255];
    char filename[255];
    dir = opendir(DEV_INPUT);
    if(dir == NULL) {
        perror("opendir");
        return -1;
        }
    while(f = readdir(dir)) {
        if(f->d_type == DT_CHR && strncmp("event", f->d_name, 5) == 0) {
            sprintf(filename, DEV_INPUT "/%s", f->d_name);
            fd = open(filename, O_RDONLY);
            ioctl(fd, EVIOCGNAME(255), name);
            close(fd);
            printf("%s\t%s\n", name, filename);
            }
        }
    return 0;
    }

